#include <p30fxxxx.h>
#include <xlcd.h>

/*External LCD functions are only defined for the following devices */
#if defined(__dsPIC30F5011__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/*******************************************************************
Function Name:          PutsXLCD
Description:            This function writes a string of characters 
                        into the LCD controller.it stops transmission
                        before the null character.(which is not sent).
Input parameters:       char  *buffer 
Return value:           void
********************************************************************/

void PutsXLCD(char *buffer)
{
    while(*buffer != '\0')
    {
        while(BusyXLCD());      /* wait till LCD controller is  busy */
        WriteDataXLCD(*buffer); /* calling another function */
                                /* to write each char to the lcd module */
        buffer++;
    }
} /* end of function */

#endif
/* end of file */
